<?php
require_once 'Haversine.php';


// EXAMPLE 1
//Making a single calcule
$haversine = new Haversine(
	array(
		'lat' => -22.98293,
		'lon' => -43.20425
	),
	array(
		'lat' => -22.98293,
		'lon' => -43.10525
	)
);

echo $haversine;
//Outputs 10,13km



// EXAMPLE 2
//Making multiple calcules and change the default unit to miles
$myHome = array(
		'lat' => -22.98293,
		'lon' => -43.20425
);

$points = array(
	'neighborhood' => array(
		'lat' => -22.98293,
		'lon' => -43.20725
	),
	'some store' => array(
		'lat' => -22.98793,
		'lon' => -43.20925
	),
	'very far' => array(
		'lat' => -22.28793,
		'lon' => -43.90925
	),
);

$haversine = new Haversine();
$haversine->setDefaultUnit(Haversine::MILE);
$haversine->setPoint1($myHome);
foreach ($points as $name => $point)
{
	$haversine->setPoint2($point);
	echo "{$name}: {$haversine}<br />";
}
/*
Outputs

neighborhood: 0,19mi
some store: 0,47mi
very far: 65,78mi
 */
	


// EXAMPLE 3
//Getting the float result

// (...)
echo $haversine->km;
//Outputs 105.86440287992

echo $haversine->mi;
//Outputs 65.781090207863

echo $haversine->ft;
//Outputs 347324.15695811