<?php
include("NewPasswordValidator.php");

//Example of use:
$pass = "ab c";
$pv = new NewPasswordValidator($pass);

//Without running a validator method, the password is considered valid:
echo "START: Is password valid?: ". $pv->getValid()." - Yes!\n";

//Run a few validators...
$pv->validate_length(6, 50);//Password must be at least 6 characters long in this example, and less than 50
$pv->validate_non_numeric(1);//Password must have 1 non-alpha character in it.
$pv->validate_whitespace();//No whitespace please
$pv->validate_no_uppercase(); //No uppercase characters
$pv->validate_custom("/[a-z]{3}[0-9]{5}/i", "Password must be 3 letters followed by 5 numbers");

//Evaluate success
echo $pv->getError();
echo "END: Is password valid?: ". $pv->getValid()." - No!\n";

?>