﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using GridDemo.Models;

namespace JqGridWithQTipIntegration.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            ViewBag.Message = " ASP.NET MVC, JQGrid and Qtip";

            return View();
        }
        public ActionResult GridDemoData(int page, int rows, string search, string sidx, string sord)
        {
            int currentPage = Convert.ToInt32(page) - 1;
            int totalRecords = 0;
            var repository = new Repository();
            var data = repository.SelectAll();
            totalRecords = data.Count();
            var totalPages = (int)Math.Ceiling(totalRecords / (float)rows);
            var jsonData = new
            {
                total = totalPages,
                page,
                records = totalRecords,

                rows = (
                           from m in data
                           select new
                           {
                               id = m.Id,
                               cell = new object[]
                                                                            {
                                                                             
                                                                                m.IntProperty,
                                                                                m.StringProperty,
                                                                                String.Format("{0:MM/dd/yyyy}", m.DateProperty)
                                                                            }
                           }).ToArray()
            };
            return Json(jsonData, JsonRequestBehavior.AllowGet);

        }
        public ActionResult About()
        {
            return View();
        }
    }
}
