<?php
/*

DOCUMENTAO DA CLASSE DatabaseOperations::
ESCRITA POR ADERBAL NUNES - JOO PESSOA - PB, BRASIL, EM 20-04-2006

########################################################################

CLASSE DatabaseOperations

$data = new DatabaseOperations;

funo setTabela()
ex: $data->setTabela("nome_da_tabela");
desc: Armazena o nome da tabela.
-----------------------------------------

funo setSql()
ex: $data->setSql( $data->MysqlEXE($data->setQuery("SELECT * FROM tabela")) );
desc: Armazena uma query executada.
-------------------------------------------

funo setQuery()
ex: $data->setQuery("SELECT * FROM tabela");
desc: ARmazena uma query.
-------------------------------------------

funo Conecta()
ex: $data->Conecta("localhost", "user_root", "senha", "base_de_dados");
desc: Conecta a base de dados.
-----------------------------------------------------------------------

funo Desconecta()
ex: $data->Desconecta();
desc: Desconecta a base de dados.
----------------------------------

funo Fieldstabela()
ex: $data->Fieldstabela("tabela");
desc: Retorna o nome dos campos das tabelas.
--------------------------------------------

funo Campos()
ex: $data->Campos("nome_da_tabela");
desc: Monta os campos de uma tabela pra usar um INSERT INTO tabela (campo1, campo2, campo3...)
----------------------------------------------------------------------------------------------

funo Values()
ex: $data->Values(array("NULL", "valor1", "valor2"));
desc: Monta os valores que sero incluidos na tabela. Obs: Usado depois de usar Campos()
----------------------------------------------------------------------------------------

funo Insert()
ex: $data->Insert();
desc: Insere os dados em uma tabela. Obs: usado, obrigatriamente, depois de usar Campos() e Values()
-----------------------------------------------------------------------------------------------------

funo MysqlEXE()
ex: $data->MysqlEXE($data->setQuery("SELECT DISTINCT nome FROM tabela ORDER BY DESC") );
desc: Executa qualquer query e retorna a varivel $this->sql com o valor da query executada.
--------------------------------------------------------------------------------------------

funao ClearValores()
ex: $data->ClearValores($valor_a_ser_limpado);
desc: Limpa uma varivel
---------------------------------------------


funo NumReg()
ex: Para a opo 0
	$data->setTabela("nome_da_tabela");
	$data->NumReg(0);
desc: Retorna o nmero de registro de uma tabela, setada antes.

ex: Para opo 1
	$data->setQuery("SELECT DISTINCT(nome) FROM agenda ORDER BY idNome DESC");
	$data->NumReg(1);
desc: Retorna o nmero de registro resultante de uma query.		
---------------------------------------------------------------

funo: Delete()
ex: $data->Delete("primare_key=", "valor_da_condicao"); 
desc: Deleta um registro de uma tabela usando uma condio. (= != < > <= >= IS NULL, NOT NULL). Obs: usar o setTabela() antes
-----------------------------------------------------------------------------------------------------------------------------



########### 1 - EXEMPLOS DE UTILIZAO ###########################
<?php
// requer a classe
require("DatabaseOperations.inc.php");

// cria um objeto da classe
$con = new DatabaseOperations;

// conecta a base
$con->Conecta("localhost", "root", "", "test");

// seto uma query
$con->setQuery("SELECT titulo, data, preco FROM produto WHERE status=0");

// mando imprimir na tela o resultado
$con->ImprimeArrayDados();

// desconecto a base
$con->Desconecta();

?>

----------> SADA NA TELA

Titulo do produto
26-10-2006
R$ 15,00
________________________________
Ttulo do outro produto
26-12-2004
R$ 25,00
________________________________

<----------- FIM SADA NA TELA

########### 2 - EXEMPLOS DE UTILIZAO ###########################

arquivo: teste2.php

<?php
// requer a classe
require("DatabaseOperations.inc.php");

// cria um objeto da classe
$con2 = new DatabaseOperations;

// conecta a base
$con2->Conecta("localhost", "root", "", "test");

// digo qual a tabela que ele vai achar os atributos
$con2->Campos("entrada");

// os valores que vo ser inseridos na tabela (em ordem)
$con2->Values(array("NULL", "titulo", "escopo aqui", "20-04-2006", 1, "debal"));

// metodo que joga os valores ta tabela escolhida, com um teste de sucesso ou no
if($con2->Insert()){ echo "Valores salvo com sucesso"; }
else { echo "No pode ser enviado"; }

// desconecto a base
$con2->Desconecta();
?>

----------> SADA NA TELA

Valores salvo com sucesso

<----------- FIM SADA NA TELA


*/
?>