﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using DataAccessEntLib;

namespace DataAccessEntLib
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Page.IsPostBack)
                return;

            //get connection string
            string ConnectionString = ConfigurationManager.ConnectionStrings["AppData"].ToString();

            //a. read IDataReader in a loop
            try
            {
                using (IDataReader IReader = DataObject.GetIDataReader(ConnectionString, "select * from Customers"))
                {
                    bool HeaderExists = false;
                    int NumberOfCols = 5;
                    while(IReader.Read())
                    {
                        if (!HeaderExists)//add table header
                        {
                            TableRow r0=new TableRow();
                            for (int i = 0; i < NumberOfCols; i++)
                            {
                                TableCell c = new TableCell();
                                c.Controls.Add(new LiteralControl(IReader.GetName(i).ToString()));
                                r0.Cells.Add(c);
                            }
                            tblResults.Rows.Add(r0);
                            HeaderExists = true; 
                        }
                        TableRow r = new TableRow(); //add data
                        for (int i = 0; i < NumberOfCols; i++)
                        {
                            TableCell c = new TableCell();
                            c.Controls.Add(new LiteralControl(IReader[i].ToString()));
                            r.Cells.Add(c);
                        }
                        tblResults.Rows.Add(r);
                    }
                }
            }
            catch (Exception ex)
            {
                lblError1.Text = ex.Message.ToString();
            }


            //b. Bind the GridView using an IDataReader
            try
            {
                using (IDataReader IReader = DataObject.GetIDataReader(ConnectionString, "select * from Customers"))
                {
                    GridView1.DataSource = IReader;
                    GridView1.DataBind();
                }
            }
            catch (Exception ex)
            {
                lblError1.Text = ex.Message.ToString();
            }

            //c. Bind the GridView using a SqlDataReader directly cast from an IDataReader
            try
            {
                using (SqlDataReader MySqlDataReader=DataObject.GetSqlDataReader(ConnectionString, "select * from Customers"))
                {
                    GridView2.DataSource = MySqlDataReader;
                    GridView2.DataBind();
                }
            }
            catch (Exception ex)
            {
                lblError2.Text = ex.Message.ToString();
            }

            //d. Bind the GridView using a SqlDataReader properly converted from an IDataReader
            try
            {
                using (IDataReader IReader = DataObject.GetIDataReader(ConnectionString, "select * from Customers"))
                {
                    GridView3.DataSource = DataObject.CastToSqlDataReader(IReader);
                    GridView3.DataBind();
                }
            }
            catch (Exception ex)
            {
                lblError3.Text = ex.Message.ToString();
            }

            //e. Use extension method to convert an IDataReader to a SqlDataReader()
            try
            {
                using (IDataReader IReader = DataObject.GetIDataReader(ConnectionString, "select * from Customers"))
                {
                    GridView4.DataSource = IReader.ToSqlDataReader();
                    GridView4.DataBind();
                }
            }
            catch (Exception ex)
            {
                lblError4.Text = ex.Message.ToString();
            }
        }
    }
}