using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Text;
using System.Data.Common;
using System.Data.SqlClient;
using Microsoft.Practices.EnterpriseLibrary.Data;
using Microsoft.Practices.EnterpriseLibrary.Data.Sql;

namespace DataAccessEntLib
{
    /// <summary>
    /// This class illustrates the implementation of a DataReader in Enterprise Library 5.0
    /// </summary>
    public static class DataObject
    {
        #region EnterPrise Library 5.0 Code Sample
        /******code for a DataReader in Enterprise Library 5.0*****/
        //return an IDataReader
        //Param: connectionString - the actual connectionstring to database
        //Param: sqlQuery - Sql select statement for retrieving data from database
        public static IDataReader GetIDataReader(string connectionString, string sqlQuery)
        {  
            SqlDatabase db = new SqlDatabase(connectionString);
            DbCommand cmd = db.GetSqlStringCommand(sqlQuery);
            //return an IDataReader.
            return db.ExecuteReader(cmd);   
        }

        //return a SqlDataReader
        //Param: connectionString - the actual connectionstring to database
        //Param: sqlQuery - Sql select statement for retrieving data from database
        public static SqlDataReader GetSqlDataReader(string connectionString, string sqlQuery)
        {
            IDataReader IReader = GetIDataReader(connectionString, sqlQuery);
            //return a SqlDataReader by directly casting the IDataReader to a SqlDateReader
            return (SqlDataReader) IReader;
        }

        //convert the innerReader of the IDataReader to a SqlDataReader
        public static SqlDataReader CastToSqlDataReader(IDataReader iReader)
        {
            //Cast IDataReader to RefCountingDataReader first, 
            //and then cast the innerReader of the RefCountingDataReader to SqlDataReader
            return (SqlDataReader)((RefCountingDataReader)iReader).InnerReader;
        }
        #endregion


        #region EnterPrise Library 3.1 Code Sample for comparison
        /******code for a DataReader in Enterprise Library 3.1*****/
        //return a SqlDataReader in Version 3.1. 
        //Param: connectionStringName - the name of your connectionstring in web.config
        //Param: sqlQuery - Sql statement for acquiring data from database
        public static SqlDataReader GetSqlDataReader_V3(string connectionStringName, string sqlQuery)
        {
            Database db = DatabaseFactory.CreateDatabase(connectionStringName);
            DbCommand cmd = db.GetSqlStringCommand(sqlQuery);
            //return a SqlDataReader by directly converting the IDataReader to a SqlDataReader
            return (SqlDataReader)db.ExecuteReader(cmd);
        }
        #endregion
    }



    /// <summary>
    ///This class implements an extension method to convert an IDataReader to a SqlDataReader
    /// </summary>
    public static class DataAccessEntLibExtension
    {
        public static SqlDataReader ToSqlDataReader(this IDataReader reader)
        {
            return (SqlDataReader)((RefCountingDataReader)reader).InnerReader;
        }
    }
}
