﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NorthwindApplicationServices;
using NorthwindViewModel;

namespace NorthwindWebApplication.Controllers
{
    public class ProductsController : Controller
    {
        //
        // GET: /Products/

        public ActionResult Index()
        {
            return View();
        }

        public ActionResult BeginProductInquiry()
        {
            return PartialView("ProductInquiry");
        }

        public ActionResult GetProductInformation(string productID)
        {
            int productNumber = 0;

            if (NorthwindBusinessServices.Utilities.IsNumeric(productID) == true) 
               productNumber = Convert.ToInt32(productID);

            ProductApplicationService productApplicationService = new ProductApplicationService();
            ProductViewModel productViewModel = productApplicationService.GetProductInformation(productNumber);

            return Json(new
            {
                ReturnStatus = productViewModel.ReturnStatus,
                ViewModel = productViewModel,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", productViewModel)
            });

        }
      

        /// <summary>
        /// Product Inquiry
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult ProductInquiry(FormCollection postedFormData)
        {

            ProductApplicationService productApplicationService = new ProductApplicationService();
            ProductViewModel productViewModel = new ProductViewModel();

            productViewModel.PageSize = Convert.ToInt32(postedFormData["PageSize"]);
            productViewModel.SortExpression = Convert.ToString(postedFormData["SortExpression"]);
            productViewModel.SortDirection = Convert.ToString(postedFormData["SortDirection"]);
            productViewModel.CurrentPageNumber = Convert.ToInt32(postedFormData["CurrentPageNumber"]);
            productViewModel.PageID = Convert.ToString(postedFormData["PageID"]);

            if (NorthwindBusinessServices.Utilities.IsNumeric(postedFormData["ProductID"]) == true)
                productViewModel.Product.ProductID = Convert.ToInt32(postedFormData["ProductID"]);
            
            productViewModel.Product.ProductName = Convert.ToString(postedFormData["ProductName"]);
         
            productViewModel = productApplicationService.ProductInquiry(productViewModel);

            return Json(new
            {
                ReturnStatus = productViewModel.ReturnStatus,
                ViewModel = productViewModel,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", productViewModel),
                ProductInquiryView = Helpers.MvcHelpers.RenderPartialView(this, "ProductInquiryGrid", productViewModel)
            });

        }

    }
}
