﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NorthwindApplicationServices;
using NorthwindViewModel;

namespace NorthwindWebApplication.Controllers
{
    public class OrdersController : Controller
    {
       
        /// <summary>
        /// Begin Order Entry
        /// </summary>
        /// <returns></returns>
        public ActionResult OrderEntryCustomerList()
        {        
            return View("OrderEntryCustomerList");
        }

        /// <summary>
        /// Begin Order Inquiry
        /// </summary>
        /// <returns></returns>
        public ActionResult BeginOrderInquiry()
        {
            return View("OrderInquiry");
        }


        /// <summary>
        /// Start Order Entry
        /// </summary>
        /// <param name="customerID"></param>
        /// <returns></returns>
        public ActionResult StartOrderEntry(string customerID)
        {
            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel  = orderApplicationService.BeginOrderEntry(customerID);
            return View("OrderEntryHeader", orderViewModel);
        }

        /// <summary>
        /// Create Order
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult CreateOrder(FormCollection postedFormData)
        {

            OrderViewModel orderViewModel = new OrderViewModel();

            orderViewModel.Order.CustomerID = Convert.ToString(postedFormData["CustomerID"]);
            orderViewModel.Order.ShipName = Convert.ToString(postedFormData["ShipName"]);
            orderViewModel.Order.ShipAddress = Convert.ToString(postedFormData["ShipAddress"]);
            orderViewModel.Order.ShipCity = Convert.ToString(postedFormData["ShipCity"]);
            orderViewModel.Order.ShipCountry = Convert.ToString(postedFormData["ShipCountry"]);
            orderViewModel.Order.ShipRegion = Convert.ToString(postedFormData["ShipRegion"]);

            if (NorthwindBusinessServices.Utilities.IsNumeric(postedFormData["Shipper"]) == true)
                orderViewModel.Order.ShipVia = Convert.ToInt32(postedFormData["Shipper"]);
            
            orderViewModel.Order.ShipPostalCode = Convert.ToString(postedFormData["ShipPostalCode"]);

            if (NorthwindBusinessServices.Utilities.IsDate(postedFormData["RequiredDate"])==true)
                orderViewModel.Order.RequiredDate = Convert.ToDateTime(postedFormData["RequiredDate"]);

            OrderApplicationService orderApplicationService = new OrderApplicationService();
            orderViewModel = orderApplicationService.CreateOrder(orderViewModel);
          
            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                ValidationErrors = orderViewModel.ValidationErrors,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),               
            });
        
        }


        /// <summary>
        /// Create Order
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult UpdateOrder(FormCollection postedFormData)
        {

            OrderViewModel orderViewModel = new OrderViewModel();

            orderViewModel.Order.OrderID = Convert.ToInt32(postedFormData["OrderID"]);
            orderViewModel.Order.CustomerID = Convert.ToString(postedFormData["CustomerID"]);
            orderViewModel.Order.ShipName = Convert.ToString(postedFormData["ShipName"]);
            orderViewModel.Order.ShipAddress = Convert.ToString(postedFormData["ShipAddress"]);
            orderViewModel.Order.ShipCity = Convert.ToString(postedFormData["ShipCity"]);
            orderViewModel.Order.ShipCountry = Convert.ToString(postedFormData["ShipCountry"]);
            orderViewModel.Order.ShipRegion = Convert.ToString(postedFormData["ShipRegion"]);
         
            if (NorthwindBusinessServices.Utilities.IsNumeric(postedFormData["Shipper"]) == true)
                orderViewModel.Order.ShipVia = Convert.ToInt32(postedFormData["Shipper"]);

            orderViewModel.Order.ShipPostalCode = Convert.ToString(postedFormData["ShipPostalCode"]);

            if (NorthwindBusinessServices.Utilities.IsDate(postedFormData["RequiredDate"]) == true)
                orderViewModel.Order.RequiredDate = Convert.ToDateTime(postedFormData["RequiredDate"]);

            OrderApplicationService orderApplicationService = new OrderApplicationService();
            orderViewModel = orderApplicationService.UpdateOrder(orderViewModel);

            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                ValidationErrors = orderViewModel.ValidationErrors,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),
            });

        }

        /// <summary>
        /// Order Entry Detail
        /// </summary>
        /// <param name="orderID"></param>
        /// <returns></returns>
        public ActionResult OrderEntryDetail(int orderID)
        {
            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel = orderApplicationService.GetOrderDetails(orderID);

            return View("OrderEntryDetail", orderViewModel);
        }

        /// <summary>
        /// Order Edit
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult OrderEdit(int orderID)
        {
            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel = orderApplicationService.BeginOrderEdit(orderID);
            return View("OrderEntryHeader", orderViewModel);
        }

        /// <summary>
        /// Add Order Detail Line Item
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult AddOrderDetailLineItem(FormCollection postedFormData)
        {
            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel = new OrderViewModel();

            orderViewModel.OrderDetail.OrderID = Convert.ToInt32(postedFormData["OrderID"]);
            orderViewModel.OrderDetail.ProductID = Convert.ToInt32(postedFormData["ProductID"]);

            if (NorthwindBusinessServices.Utilities.IsNumeric((postedFormData["Quantity"])) == true)
                orderViewModel.OrderDetail.Quantity = Convert.ToInt32(postedFormData["Quantity"]);

            if (NorthwindBusinessServices.Utilities.IsDouble((postedFormData["Discount"])) == true)
                orderViewModel.OrderDetail.Discount = Convert.ToDouble(postedFormData["Discount"]);

            orderViewModel = orderApplicationService.AddOrderDetailLineItem(orderViewModel);

            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                ValidationErrors = orderViewModel.ValidationErrors,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),
            });


        }

        /// <summary>
        /// Update Order Detail Line Item
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult UpdateOrderDetailLineItem(FormCollection postedFormData)
        {
            string rowIndex = Convert.ToString( postedFormData["RowIndex"]);

            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel = new OrderViewModel();

            orderViewModel.OrderDetail.OrderID = Convert.ToInt32(postedFormData["OrderID"]);
            orderViewModel.OrderDetail.ProductID = Convert.ToInt32(postedFormData["ProductID"]);

            if (NorthwindBusinessServices.Utilities.IsNumeric((postedFormData["Quantity"])) == true)
                orderViewModel.OrderDetail.Quantity = Convert.ToInt32(postedFormData["Quantity"]);

            if (NorthwindBusinessServices.Utilities.IsDouble((postedFormData["Discount"])) == true)
                orderViewModel.OrderDetail.Discount = Convert.ToDouble(postedFormData["Discount"]);          

            orderViewModel = orderApplicationService.UpdateOrderDetailLineItem(orderViewModel);

            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                RowIndex = rowIndex,
                ValidationErrors = orderViewModel.ValidationErrors,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),
            });

        }

        /// <summary>
        /// Update Order Detail Line Item
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult DeleteOrderDetailLineItem(FormCollection postedFormData)
        {
            string rowIndex = Convert.ToString(postedFormData["RowIndex"]);
            string productName = Convert.ToString(postedFormData["ProductName"]);
            int orderID = Convert.ToInt32(postedFormData["OrderID"]);
            int productID = Convert.ToInt32(postedFormData["ProductID"]);
       
            OrderApplicationService orderApplicationService = new OrderApplicationService();

            OrderViewModel orderViewModel = new OrderViewModel();
            orderViewModel.OrderLineItem.OrderDetails.OrderID = orderID;
            orderViewModel.OrderLineItem.OrderDetails.ProductID = productID;
            orderViewModel.OrderLineItem.Products.ProductName = productName;

            orderViewModel = orderApplicationService.DeleteOrderDetailLineItem(orderViewModel);

            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                RowIndex = rowIndex,
                ValidationErrors = orderViewModel.ValidationErrors,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),
            });

        }


        /// <summary>
        /// Customer Inquiry
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult CustomerInquiry(FormCollection postedFormData)
        {
          
            CustomerApplicationService customerApplicationService = new CustomerApplicationService();
            CustomerViewModel customerViewModel = new CustomerViewModel();

            customerViewModel.PageSize = Convert.ToInt32(postedFormData["PageSize"]);
            customerViewModel.SortExpression = Convert.ToString(postedFormData["SortExpression"]);
            customerViewModel.SortDirection = Convert.ToString(postedFormData["SortDirection"]);
            customerViewModel.CurrentPageNumber = Convert.ToInt32(postedFormData["CurrentPageNumber"]);
            customerViewModel.Customer.CustomerID = Convert.ToString(postedFormData["CustomerID"]); 
            customerViewModel.Customer.CompanyName = Convert.ToString(postedFormData["CompanyName"]);
            customerViewModel.Customer.ContactName = Convert.ToString(postedFormData["ContactName"]); 

            customerViewModel = customerApplicationService.CustomerInquiry(customerViewModel);
            
            return Json(new
            {
                ReturnStatus = customerViewModel.ReturnStatus,
                ViewModel = customerViewModel,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", customerViewModel),
                CustomerInquiryView = Helpers.MvcHelpers.RenderPartialView(this, "CustomerInquiryGrid", customerViewModel)
            });

        }

        /// <summary>
        /// Order Inquiry
        /// </summary>
        /// <param name="postedFormData"></param>
        /// <returns></returns>
        public ActionResult OrderInquiry(FormCollection postedFormData)
        {

            OrderApplicationService orderApplicationService = new OrderApplicationService();
            OrderViewModel orderViewModel = new OrderViewModel();

            orderViewModel.PageSize = Convert.ToInt32(postedFormData["PageSize"]);
            orderViewModel.SortExpression = Convert.ToString(postedFormData["SortExpression"]);
            orderViewModel.SortDirection = Convert.ToString(postedFormData["SortDirection"]);
            orderViewModel.CurrentPageNumber = Convert.ToInt32(postedFormData["CurrentPageNumber"]);
            orderViewModel.Customer.CustomerID = Convert.ToString(postedFormData["CustomerID"]);
            orderViewModel.Customer.CompanyName = Convert.ToString(postedFormData["CompanyName"]);

            if (NorthwindBusinessServices.Utilities.IsNumeric((postedFormData["OrderID"]))==true)
                orderViewModel.Order.OrderID = Convert.ToInt32(postedFormData["OrderID"]);

            orderViewModel = orderApplicationService.OrderInquiry(orderViewModel);

            return Json(new
            {
                ReturnStatus = orderViewModel.ReturnStatus,
                ViewModel = orderViewModel,
                MessageBoxView = Helpers.MvcHelpers.RenderPartialView(this, "_MessageBox", orderViewModel),
                OrderInquiryView = Helpers.MvcHelpers.RenderPartialView(this, "OrderInquiryGrid", orderViewModel)
            });

        }


    }
}
