﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NorthwindDataModel;

namespace NorthwindDataAccessServices
{
    public class ProductDataAccessService
    {

        private Products LoadProducts(SqlDataReader sqlDataReader)
        {
            Products products = new Products();

            DataReader dataReader = new DataReader(sqlDataReader);

            products.ProductID  = dataReader.GetInt32("ProductID");
	        products.ProductName = dataReader.GetString("ProductName");
            products.QuantityPerUnit = dataReader.GetString("QuantityPerUnit");
	        products.UnitPrice  = dataReader.GetFloat("UnitPrice");

            products.ProductIDFormatted = products.ProductID.ToString("D" + 6);
            products.UnitPriceFormatted = products.UnitPrice.ToString("C");
         
            return products;

        }

        public Products GetProductInformation(int productID)
        {
            Products product = new Products();
            product.ProductID = 0;

            string sql = "SELECT * FROM PRODUCTS WHERE PRODUCTID = @PRODUCTID";

            SqlCommand sqlCommand = new SqlCommand();
            sqlCommand.CommandText = sql;

            sqlCommand.Parameters.Add("@PRODUCTID", SqlDbType.Int);
            sqlCommand.Parameters["@PRODUCTID"].Value = productID;

            using (ADODataService.DataAccess adoDataService = new ADODataService.DataAccess())
            {
                SqlDataReader sqlDataReader = adoDataService.ExecuteReader(sqlCommand);

                if (sqlDataReader.Read()==true)
                    product = LoadProducts(sqlDataReader);

                sqlDataReader.Close();
                adoDataService.Dispose();
                
            }

            return product;
           
        }

        public Boolean DoesProductExist(int productID)
        {
            Boolean returnStatus = false;

            string sql = "SELECT PRODUCTID FROM PRODUCTS WHERE PRODUCTID = @PRODUCTID";

            SqlCommand sqlCommand = new SqlCommand();
            sqlCommand.CommandText = sql;

            sqlCommand.Parameters.Add("@PRODUCTID", SqlDbType.Int);
            sqlCommand.Parameters["@PRODUCTID"].Value = productID;

            using (ADODataService.DataAccess adoDataService = new ADODataService.DataAccess())
            {
                using (SqlDataReader sqlDataReader = adoDataService.ExecuteReader(sqlCommand))
                {

                    if (sqlDataReader.Read() == true)
                        returnStatus = true;

                    sqlDataReader.Close();                   

                }

                adoDataService.Dispose();
            }

            return returnStatus;

        }


        /// <summary>
        /// Product Inquiry
        /// </summary>
        /// <param name="customer"></param>
        /// <param name="currentPageNumber"></param>
        /// <param name="sortExpression"></param>
        /// <param name="sortDirection"></param>
        /// <param name="pageSize"></param>
        /// <param name="totalRecords"></param>
        /// <returns></returns>
        public List<Products> ProductInquiry(Products product,
                                              int currentPageNumber,
                                              string sortExpression,
                                              string sortDirection,
                                              int pageSize, out int totalRecords)
        {

            int maxRowNumber;
            int minRowNumber;
            string sqlWhere = String.Empty;

            if (sortExpression == "") sortExpression = "ProductName";
            if (sortDirection == "") sortDirection = "ASC";

            minRowNumber = (pageSize * (currentPageNumber - 1)) + 1;
            maxRowNumber = pageSize * currentPageNumber;

            StringBuilder sqlBuilder = new StringBuilder();
            StringBuilder sqlWhereBuilder = new StringBuilder();

            if (product.ProductName != null && product.ProductName.Trim().Length > 0)
                sqlWhereBuilder.Append(" ProductName LIKE @PRODUCTNAME AND ");


            if (product.ProductID != null && product.ProductID > 0)
                sqlWhereBuilder.Append(" ProductID = @PRODUCTID AND ");

            if (sqlWhereBuilder.Length > 0)
                sqlWhere = " WHERE " + sqlWhereBuilder.ToString().Substring(0, sqlWhereBuilder.Length - 4);

            sqlBuilder.Append(" SELECT COUNT(*) as total_records FROM Products ");
            sqlBuilder.Append(sqlWhere);
            sqlBuilder.Append(";");
            sqlBuilder.Append(" SELECT * FROM ( ");
            sqlBuilder.Append(" SELECT (ROW_NUMBER() OVER (ORDER BY " + sortExpression + " " + sortDirection + ")) as record_number, ProductID, ProductName, QuantityPerUnit, UnitPrice  ");
            sqlBuilder.Append(" FROM Products ");
            sqlBuilder.Append(sqlWhere);
            sqlBuilder.Append(" ) Rows ");
            sqlBuilder.Append(" where record_number between " + minRowNumber + " and " + maxRowNumber);

            string sql = sqlBuilder.ToString();

            SqlCommand sqlCommand = new SqlCommand();
            sqlCommand.CommandText = sql;

            List<Products> listOfProducts = new List<Products>();

            if (product.ProductID != null && product.ProductID > 0)
            {
                sqlCommand.Parameters.Add("@PRODUCTID", SqlDbType.Int);
                sqlCommand.Parameters["@PRODUCTID"].Value = product.ProductID;
            }


            if (product.ProductName != null && product.ProductName.Trim().Length > 0)
            {
                sqlCommand.Parameters.Add("@PRODUCTNAME", SqlDbType.VarChar);
                sqlCommand.Parameters["@PRODUCTNAME"].Value = product.ProductName + "%";
            }

            using (ADODataService.DataAccess adoDataService = new ADODataService.DataAccess())
            {

                SqlDataReader sqlDataReader = adoDataService.ExecuteReader(sqlCommand);

                sqlDataReader.Read();
                totalRecords = Convert.ToInt32(sqlDataReader["Total_Records"]);

                sqlDataReader.NextResult();

                while (sqlDataReader.Read())
                {
                    Products productInformation = LoadProducts(sqlDataReader);
                    listOfProducts.Add(productInformation);
                }

                sqlDataReader.Close();               
                adoDataService.Dispose();

                return listOfProducts;

            }



        }
    }
}
