﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NorthwindDataModel;


namespace NorthwindDataAccessServices
{


    public class CustomerDataAccessService
    {

        private Customer LoadCustomer(SqlDataReader sqlDataReader)
        {
            Customer customer = new Customer();

            DataReader dataReader = new DataReader(sqlDataReader);
           
            customer.CustomerID = dataReader.GetString("CustomerID");
            customer.CompanyName = dataReader.GetString("CompanyName");
            customer.ContactName = dataReader.GetString("ContactName");
            customer.ContactTitle = dataReader.GetString("ContactTitle");
            customer.City = dataReader.GetString("City");
            customer.Region = dataReader.GetString("Region");
            customer.Address = dataReader.GetString("Address");
            customer.PostalCode = dataReader.GetString("PostalCode");
            customer.Country = dataReader.GetString("Country");
            customer.Phone = dataReader.GetString("Phone");
            customer.Fax = dataReader.GetString("Fax");

            return customer;

        }

        public Customer GetCustomerInformation(string customerID)
        {

            string sql = "SELECT * FROM CUSTOMERS WHERE CUSTOMERID = @CUSTOMERID";

            SqlCommand sqlCommand = new SqlCommand();
            sqlCommand.CommandText = sql;

            sqlCommand.Parameters.Add("@CUSTOMERID", SqlDbType.VarChar);
            sqlCommand.Parameters["@CUSTOMERID"].Value = customerID;

            ADODataService.DataAccess adoDataService = new ADODataService.DataAccess();
            SqlDataReader sqlDataReader = adoDataService.ExecuteReader(sqlCommand);

            sqlDataReader.Read();

            Customer customer = LoadCustomer(sqlDataReader);

            sqlDataReader.Close();
            adoDataService.Dispose();

            return customer;

        }

        /// <summary>
        /// Customer Inquiry
        /// </summary>
        /// <param name="customerID"></param>
        /// <param name="customerName"></param>
        /// <param name="currentPageNumber"></param>
        /// <param name="pageSize"></param>
        /// <param name="totalRecords"></param>
        /// <returns></returns>
        public List<Customer> CustomerInquiry(Customer customer, 
                                              int currentPageNumber, 
                                              string sortExpression, 
                                              string sortDirection,   
                                              int pageSize, out int totalRecords)
        {

            int maxRowNumber;
            int minRowNumber;
            string sqlWhere = String.Empty;

            if (sortExpression == "") sortExpression = "CompanyName";
            if (sortDirection == "") sortDirection = "ASC";

            minRowNumber = (pageSize * (currentPageNumber - 1)) + 1;
            maxRowNumber = pageSize * currentPageNumber;

            StringBuilder sqlBuilder = new StringBuilder();
            StringBuilder sqlWhereBuilder = new StringBuilder();
            
            if (customer.CompanyName != null && customer.CompanyName.Trim().Length > 0)
                sqlWhereBuilder.Append(" CompanyName LIKE @COMPANYNAME AND ");

            if (customer.ContactName != null && customer.ContactName.Trim().Length > 0)
                sqlWhereBuilder.Append(" ContactName LIKE @CONTACTNAME AND ");

            if (customer.CustomerID != null && customer.CustomerID.Trim().Length > 0)
                sqlWhereBuilder.Append(" CustomerID LIKE @CUSTOMERID AND ");

            if (sqlWhereBuilder.Length>0) 
                sqlWhere = " WHERE " + sqlWhereBuilder.ToString().Substring(0,sqlWhereBuilder.Length-4);

            sqlBuilder.Append(" SELECT COUNT(*) as total_records FROM Customers ");
            sqlBuilder.Append(sqlWhere);
            sqlBuilder.Append(";");
            sqlBuilder.Append(" SELECT * FROM ( ");
            sqlBuilder.Append(" SELECT (ROW_NUMBER() OVER (ORDER BY " + sortExpression + " " + sortDirection + ")) as record_number, CustomerID, CompanyName, ContactName, ContactTitle, City, Region ");
            sqlBuilder.Append(" FROM Customers ");
            sqlBuilder.Append(sqlWhere);
            sqlBuilder.Append(" ) Rows ");
            sqlBuilder.Append(" where record_number between " + minRowNumber + " and " + maxRowNumber);

            string sql = sqlBuilder.ToString();

            SqlCommand sqlCommand = new SqlCommand();
            sqlCommand.CommandText = sql;

            List<Customer> listOfCustomers = new List<Customer>();

            if (customer.CustomerID != null && customer.CustomerID.Trim().Length > 0)
            {
                sqlCommand.Parameters.Add("@CUSTOMERID", SqlDbType.VarChar);
                sqlCommand.Parameters["@CUSTOMERID"].Value = customer.CustomerID + "%";
            }


            if (customer.CompanyName != null && customer.CompanyName.Trim().Length > 0)
            {
                sqlCommand.Parameters.Add("@COMPANYNAME", SqlDbType.VarChar);
                sqlCommand.Parameters["@COMPANYNAME"].Value = customer.CompanyName + "%";
            }

            if (customer.ContactName != null && customer.ContactName.Trim().Length > 0)
            {
                sqlCommand.Parameters.Add("@CONTACTNAME", SqlDbType.VarChar);
                sqlCommand.Parameters["@CONTACTNAME"].Value = customer.ContactName + "%";
            }


            using (ADODataService.DataAccess adoDataService = new ADODataService.DataAccess())
            {
            
                SqlDataReader sqlDataReader = adoDataService.ExecuteReader(sqlCommand);

                sqlDataReader.Read();
                totalRecords = Convert.ToInt32(sqlDataReader["Total_Records"]);

                sqlDataReader.NextResult();

                while (sqlDataReader.Read())
                {
                    Customer customerInformation = LoadCustomer(sqlDataReader);
                    listOfCustomers.Add(customerInformation);
                }

                sqlDataReader.Close();
                adoDataService.Dispose();

                return listOfCustomers;

            }

           

        }

      

    }
}
