﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace NorthwindBusinessServices
{
  
    public class Validations
    {

        /// <summary>
        /// Validate EmailAddress
        /// </summary>
        /// <param name="emailAddress"></param>
        /// <returns></returns>
        public static Boolean ValidateEmailAddress(object emailAddress)
        {
            //string regexPattern =  @"\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*";
            //string regexPattern = @"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";

            string pattern = @"^(([^<>()[\]\\.,;:\s@\""]+"
                       + @"(\.[^<>()[\]\\.,;:\s@\""]+)*)|(\"".+\""))@"
                       + @"((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}"
                       + @"\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+"
                       + @"[a-zA-Z]{2,}))$";

            if (emailAddress == null) return true;
            return Regex.Match(emailAddress.ToString(), pattern).Success;
        }

        /// <summary>
        /// Validate Required Entity
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean ValidateRequired(object entity)
        {
            if (entity == null) return false;
            if (entity.ToString().Length == 0) return false;
            return true;
        }

        /// <summary>
        /// Validate Length
        /// </summary>
        /// <param name="entity"></param>
        /// <param name="maxLength"></param>
        /// <returns></returns>
        public static Boolean ValidateLength(object entity, int maxLength)
        {
            if (entity == null) return true;
            if (entity.ToString().Length > maxLength) return false;
            return true;
        }

        /// <summary>
        /// Validate Greater Than Zero
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean ValidateGreaterThanZero(object entity)
        {
            if (entity == null) return false;
            if (IsNumeric(entity) == false) return false;

            int test = Convert.ToInt32(entity);
            if (test < 1) return false;    
    
            return true;
        }

        /// <summary>
        /// IsNumeric
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean IsNumeric(object entity)
        {
            if (entity == null) return false;

            int result;
            return int.TryParse(entity.ToString(), out result);        
        }

        /// <summary>
        /// Is Date
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean IsDate(object entity)
        {
            if (entity == null) return false;
            return Utilities.IsDate(entity.ToString());           
        }

        /// <summary>
        /// Is Date or Null Date
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean IsDateOrNullDate(object entity)
        {
            if (entity == null) return true;
            return Utilities.IsDate(entity.ToString());
        }

        /// <summary>
        /// Is Date Greater than default Date
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean IsDateGreaterThanDefaultDate(object entity)
        {
            if (entity == null) return false;
            if (Utilities.IsDate(entity.ToString())==false) return false;

            DateTime testDate = Convert.ToDateTime(entity.ToString());
            long test = testDate.Ticks;
            if (test == 0) return false;

            return true;

        }

        /// <summary>
        /// Is Date Greater than default Date
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public static Boolean IsDateGreaterThanOrEqualToToday(object entity)
        {
            if (entity == null) return false;
            if (Utilities.IsDate(entity.ToString()) == false) return false;

            DateTime testDate = Convert.ToDateTime(entity.ToString());
            if (testDate < DateTime.Today) return false;

            return true;

        }


    }
}

