﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NorthwindViewModel;
using NorthwindDataModel;
using NorthwindDataAccessServices;


namespace NorthwindBusinessServices
{
    public class OrderBusinessService : ValidationRules
    {

        /// <summary>
        /// Initialize Order Header
        /// </summary>
        /// <param name="customer"></param>
        /// <returns></returns>
        public Orders InitializeOrderHeader(Customer customer)
        {

            Orders order = new Orders();

            order.OrderDate = DateTime.Now;
            order.CustomerID = customer.CustomerID;
            order.ShipAddress = customer.Address;
            order.ShipCity = customer.City;
            order.ShipCountry = customer.Country;
            order.ShipName = customer.CompanyName;
            order.ShipPostalCode = customer.PostalCode;
            order.ShipRegion = customer.Region;
            order.RequiredDate = order.OrderDate;

            return order;

        }

        /// <summary>
        /// Validate Order Detail
        /// </summary>
        /// <param name="orderDetail"></param>
        /// <param name="entryMode"></param>
        public void ValidateOrderDetail(OrderDetails orderDetail, Boolean entryMode)
        {
            InitializeValidationRules(orderDetail);

            Boolean productRequired = ValidateRequired("ProductID", "Product ID");
            
            ValidateGreaterThanZero("Quantity", "Quantity");

            if (entryMode == false) return;

            if (productRequired == false) return;
                        
            ProductDataAccessService productDataAccessService = new ProductDataAccessService();
            Boolean productFound = productDataAccessService.DoesProductExist(orderDetail.ProductID);
            if (productFound == false)
            {
                ValidationError("ProductID", "Product ID not found");
                return;
            }

            OrderDataAccessService orderDataAccessService = new OrderDataAccessService();
            Boolean duplicate = orderDataAccessService.IsDuplicateLineItem(orderDetail.OrderID, orderDetail.ProductID);
            if (duplicate == true)
            {
                ValidationError("ProductID", "Product already exists on this order");
                return;
            }


        }

        /// <summary>
        /// Validate Order Header
        /// </summary>
        /// <param name="order"></param>
        /// <returns></returns>
        public void ValidateOrderHeader(Orders order)
        {

            InitializeValidationRules(order);

            ValidateRequired("ShipAddress", "Ship To Address");
            ValidateRequired("ShipCity", "Ship To City");
            ValidateRequired("ShipName", "Ship To Name");
            ValidateRequired("ShipPostalCode", "Ship To PostalCode");
            ValidateRequired("ShipRegion", "Ship To Region");
            ValidateRequired("ShipCountry", "Ship To Country");

            ValidateRequiredDate("RequiredDate", "Required Date");

            if (order.OrderID==0)
                ValidateDateGreaterThanOrEqualToToday("RequiredDate", "Required Date");  

            ValidateSelectedValue("ShipVia", "Shipper");
          
        }


        /// <summary>
        /// Create Order
        /// </summary>
        /// <param name="orderViewModel"></param>
        /// <returns></returns>
        public OrderViewModel CreateOrder(OrderViewModel orderViewModel)
        {

            return orderViewModel;

        }

    }

}

