﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NorthwindViewModel;
using NorthwindDataModel;
using NorthwindDataAccessServices;
using NorthwindBusinessServices;

namespace NorthwindApplicationServices
{
    public class ProductApplicationService
    {

        /// <summary>
        /// Get Product Information
        /// </summary>
        /// <param name="viewModel"></param>
        /// <returns></returns>
        public ProductViewModel GetProductInformation(int productID)
        {
            Products product = new Products();
            ProductViewModel productViewModel = new ProductViewModel();
      
            if (productID == 0)
            {
                List<String> returnMessage = new List<String>();
                returnMessage.Add("An invalid product ID was entered.");
                productViewModel.ReturnMessage = returnMessage;
                productViewModel.ReturnStatus = false;
                return productViewModel;
            }

            ProductDataAccessService productDataAccessService = new ProductDataAccessService();
        
            product = productDataAccessService.GetProductInformation(productID);
            productViewModel.Product = product;
            productViewModel.ReturnStatus = true;

            if (product.ProductID == 0)
            {
                List<String> returnMessage = new List<String>();
                returnMessage.Add(productID.ToString() + " is not a valid product ID");
                productViewModel.ReturnMessage = returnMessage;
                productViewModel.ReturnStatus = false;
            }
          
            return productViewModel;

        }


        /// <summary>
        /// Product Inquiry
        /// </summary>
        /// <param name="viewModel"></param>
        /// <returns></returns>
        public ProductViewModel ProductInquiry(ProductViewModel viewModel)
        {

            int totalProducts;

            List<String> returnMessage = new List<String>();

            ProductDataAccessService productDataAccessService = new ProductDataAccessService();

            try
            {
                List<Products> products = productDataAccessService.ProductInquiry(viewModel.Product,
                    viewModel.CurrentPageNumber, viewModel.SortExpression, viewModel.SortDirection,
                    viewModel.PageSize, out totalProducts);

                viewModel.TotalProducts = totalProducts;
                viewModel.TotalPages = Utilities.CalculateTotalPages(totalProducts, viewModel.PageSize);
                viewModel.Products = products;

                if (viewModel.TotalProducts > 0 && viewModel.TotalPages < viewModel.CurrentPageNumber)
                {
                    returnMessage.Add("Please resubmit your request.");
                    viewModel.ReturnMessage = returnMessage;
                    viewModel.ReturnStatus = false;
                }
                else
                {
                    returnMessage.Add(totalProducts.ToString() + " products found.");
                    viewModel.ReturnMessage = returnMessage;
                    viewModel.ReturnStatus = true;
                }

            }
            catch (Exception e)
            {
                returnMessage.Add("An application error has occurred. Please call technical support.");
                viewModel.ReturnStatus = false;
            }

            viewModel.ReturnMessage = returnMessage;

            return viewModel;

        }

    }
}
