﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NorthwindViewModel;
using NorthwindDataModel;
using NorthwindDataAccessServices;
using NorthwindBusinessServices;

namespace NorthwindApplicationServices
{
    public class CustomerApplicationService
    {

        /// <summary>
        /// Customer Inquiry
        /// </summary>
        /// <param name="viewModel"></param>
        /// <returns></returns>
        public CustomerViewModel CustomerInquiry(CustomerViewModel viewModel)
        {

            int totalCustomers;
            
            List<String> returnMessage = new List<String>();

            CustomerDataAccessService customerDataAccessService = new CustomerDataAccessService();

            try
            {
                List<Customer> customers = customerDataAccessService.CustomerInquiry(viewModel.Customer,
                    viewModel.CurrentPageNumber, viewModel.SortExpression, viewModel.SortDirection,
                    viewModel.PageSize, out totalCustomers);

                viewModel.TotalCustomers = totalCustomers;
                viewModel.TotalPages = Utilities.CalculateTotalPages(totalCustomers, viewModel.PageSize);
                viewModel.Customers = customers;                       
             
                if (viewModel.TotalCustomers > 0 && viewModel.TotalPages < viewModel.CurrentPageNumber)
                {
                    returnMessage.Add("Please resubmit your request.");
                    viewModel.ReturnMessage = returnMessage;
                    viewModel.ReturnStatus = false;                                       
                }
                else
                {
                    returnMessage.Add(totalCustomers.ToString() + " customers found.");
                    viewModel.ReturnMessage = returnMessage;
                    viewModel.ReturnStatus = true;
                }

            }
            catch (Exception e)
            {
                returnMessage.Add("An application error has occurred. Please call technical support.");
                viewModel.ReturnStatus = false;
            }
           
            viewModel.ReturnMessage = returnMessage;
            
            return viewModel;

        }


    }
}
