﻿using System.Collections.Generic;
using System.Linq;
using Search.Models;
using SimpleSearch;

namespace SearchDemo.Searchers
{

    public class ProductSearcher : Searcher
    {
        private List<Product> Products { get; set; }

        public ProductSearcher()
        {
            Products = new List<Product>
                           {
                               new Product
                                   {
                                       Name = "Electronic Rock Guitar Shirt",
                                       ShortName = "Guitar Shirt",
                                       Description =
                                           "Get a little wearable ROCK magic for yourself. The Electronic Guitar Shirt is not a toy that plays pre-canned musical riffs, it is a real musical instrument that allows you to play your favorite songs and sound great doing it.",
                                       ProductId = 1,
                                       Price = 19.99
                                   },
                               new Product
                                   {
                                       Name = "Portal Cookie Cutters",
                                       ShortName = "Cookie Cutters",
                                       Description =
                                           "At Aperture Science, there's a good amount of joking amongst test subjects and occasionally, if you're lucky, you can joke around Cave Johnson himself. Just do not, under any circumstances, bring his mother into the mix. Got it? No your mom jokes. No Yo Mama jokes. Not even a That's what she said. Cave's very sensitive about those. The penalty for joking about Cave's mom? No cookies. That's right, you'll find your Aperture Science Holiday Gift Package is missing the sandwich baggie of Mrs. Johnson's Made From Scratch Science Cookies. Then you'll have to watch everyone else enjoying delicious frosted sugar cookies in the shapes of familiar faces around Aperture Labs.",
                                       ProductId = 1,
                                       Price = 19.99
                                   },
                               new Product
                                   {
                                       Name = "Mirror Universe LED Digital Watch",
                                       ShortName = "LED Watch",
                                       Description =
                                           "What appears to be a shiny metal bracelet disguises a watch! Press the button to see the time displayed in blue LEDs and your personal message. It can be an affirmation: U R GREAT or a simple reminder for later: BUY MILK.",
                                       ProductId = 3,
                                       Price = 19.99
                                   },
                               new Product
                                   {
                                       Name = "Stand Back (Science)",
                                       ShortName = "Stand Back",
                                       Description =
                                           "Science rocks. But it's safer with goggles, eyewashes, protective clothing, and steel-toed boots. Oh, and a fire extinguisher nearby. And an evacuation plan.",
                                       ProductId = 4,
                                       Price = 19.99
                                   },
                               new Product
                                   {
                                       Name = "Ultimate 5-in-1 Geek Set",
                                       ShortName = "5in1Set",
                                       Description =
                                           "This pen has it all: stylus, flexible LED light, UV light, red laser pointer, and clip. Oh, and it has a pen in there too. That's right - all those goodies and the dang thing still writes. YAY.",
                                       ProductId = 5,
                                       Price = 6.99
                                   },
                               new Product
                                   {
                                       Name = "Electronic Firefly in a Jar",
                                       ShortName = "Firefly Jar",
                                       Description =
                                           "Looks just like a real firefly trapped in a jar. The firefly flits around the jar and even flickers and flashes. The jar is real, but the firefly is totally fake. Which means it won't die - it will just rest as you change the batteries every so often.",
                                       ProductId = 6,
                                       Price = 9.99
                                   },
                               new Product
                                   {
                                       Name = "DFX Gamer Gyroscopic Powerball",
                                       ShortName = "Gyroscopic ball",
                                       Description =
                                           "Get a smooth, non-impact workout that will help increase flexibility, quickness, range of motion, finger and grip strength. Not only will this improve your game, but it will help prevent the repetitive stress injuries that would mean Game Over.",
                                       ProductId = 7,
                                       Price = 64.99
                                   },
                               new Product
                                   {
                                       Name = "Unicorn Chopsticks",
                                       ShortName = "Chopsticks",
                                       Description =
                                           "What's more magical than a pair of tiny unicorns with overgrown horns? Turning them upside down and using them to eat your favorite Asian foods, that's what! They'll even stand on their tiny hooves to prevent your chopsticks from touching the table.",
                                       ProductId = 8,
                                       Price = 9.99
                                   },
                               new Product
                                   {
                                       Name = "Pocket Ref 4th Edition",
                                       ShortName = "Pocket Ref",
                                       Description =
                                           "To be a real DIY dude (or dudette), you really need to know a ton of information about wiring, glues, atomic density, etc. Or, you could just keep this book in your pocket. It has, without hyperbole, almost everything you'd ever need to know ever in it.",
                                       ProductId = 9,
                                       Price = 9.99
                                   },
                               new Product
                                   {
                                       Name = "Star Trek Enterprise Pizza Cutter",
                                       ShortName = "Enterprise Cutter",
                                       Description =
                                           "Space... the final frontier. These are the voyages of the starship Enterprise. Its five-year mission: to explore strange new pizzas, to seek out new toppings and new cheeses, to boldy cut pizza where no man has cut before! Yes, this officially licensed Star Trek collectable is everything you hoped it would be. Laser etched stainless steel blade and solid metal construction make it perfect for battling Romulans in the neutral zone or precision pizza slicing.",
                                       ProductId = 10,
                                       Price = 19.99
                                   }
                           };
            //Products taken from thinkgeek.com home page 19/12/2011.
        }

        public override IEnumerable<SearchResult> Search(string searchTerm)
        {
            var result = Products.Where(p => p.Description.ToLower().Contains(searchTerm.ToLower()) || p.Name.ToLower().Contains(searchTerm.ToLower()))
                .Select(p => new SearchResult
                {
                    Category = "Product",
                    Description = p.Name,
                    Id = p.ProductId,
                    OriginatingObject = p
                }).ToList();

            result.ForEach(p => p.RouteInformation = GetRouteInfo(p.Id));

            return result;
        }

        private static Dictionary<string, string> GetRouteInfo(int id)
        {
            return new Dictionary<string, string>
                                    {
                                        {"controller", "product"},
                                        {"action", "details"},
                                        {"Id", id.ToString()}
                                    };
        }
    }

    public class CompanySearcher : Searcher
    {
        private List<Company> Companies { get; set; }

        public CompanySearcher()
        {
            Companies = new List<Company>
                            {
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 1,
                                        CreditLimit = 1000,
                                        CurrentCredit = 1100,
                                        Name = "Mircosift"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 2,
                                        CreditLimit = 100,
                                        CurrentCredit = 21.65,
                                        Name = "Yippee!"
                                    },
                                new Company
                                    {
                                        Active = false,
                                        CompanyId = 3,
                                        CreditLimit = 1000,
                                        CurrentCredit = 900,
                                        Name = "Gaggle"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 4,
                                        CreditLimit = 10000,
                                        CurrentCredit = 1100,
                                        Name = "Bong"
                                    },
                                new Company
                                    {
                                        Active = false,
                                        CompanyId = 5,
                                        CreditLimit = 4963,
                                        CurrentCredit = 6486,
                                        Name = "Space-Y"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 6,
                                        CreditLimit = 500,
                                        CurrentCredit = 420,
                                        Name = "Trashem"
                                    },
                                new Company
                                    {
                                        Active = false,
                                        CompanyId = 7,
                                        CreditLimit = 100,
                                        CurrentCredit = 19.99,
                                        Name = "ChopperBrains"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 8,
                                        CreditLimit = 800,
                                        CurrentCredit = 784,
                                        Name = "ADSA"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 9,
                                        CreditLimit = 850,
                                        CurrentCredit = 400,
                                        Name = "Tuskali"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 10,
                                        CreditLimit = 425,
                                        CurrentCredit = 350,
                                        Name = "Vargin"
                                    },
                                new Company
                                    {
                                        Active = true,
                                        CompanyId = 11,
                                        CreditLimit = 425,
                                        CurrentCredit = 350,
                                        Name = "Star"
                                    }
                            };
        }

        public override IEnumerable<SearchResult> Search(string searchTerm)
        {
            var result = Companies.Where(p => p.Name.ToLower().Contains(searchTerm))
                .Select(p => new SearchResult
                {
                    Category = "Company",
                    Description = p.Name,
                    Id = p.CompanyId,
                    OriginatingObject = p
                }).ToList();

            result.ForEach(p => p.RouteInformation = GetRouteInfo(p.Id));

            return result;
        }

        private static Dictionary<string, string> GetRouteInfo(int id)
        {
            return new Dictionary<string, string>
                                    {
                                        {"controller", "company"},
                                        {"action", "Details"},
                                        {"companyId", id.ToString()}
                                    };
        }
    }
}