﻿using System.Collections.Generic;
using System.Web.Mvc;
using SearchDemo.Searchers;
using SimpleSearch;

namespace SearchDemo.Controllers
{
    public class SearchController : Controller
    {
        private SearchCore SearchCore { get; set; }

        public SearchController()
        {
            var searchers = new List<Searcher> {new ProductSearcher(), new CompanySearcher()};

            SearchCore = new SearchCore(searchers);
        }
        
        //Uncomment below to enable caching.
        //[OutputCache(VaryByParam = "searchTerm", Duration = 180)]
        [HttpPost]
        public ActionResult Search(string searchTerm)
        {
            var model = new SearchResponse();

            //Use a stopwatch to measure the time it takes to perform the search.
            var s = new System.Diagnostics.Stopwatch();
            s.Start();
            model.Results = SearchCore.Search(searchTerm);
            s.Stop();
            model.OriginalSearchTerm = searchTerm;
            model.TimeTaken = s.Elapsed;
            return View(model);
        }

    }
}
